<?php
/**
 * Register theme post types and taxonomies
 */

function _crum_form_createLabels( $overrides = array() ) {
	$defaults = array(

		'name'               => __( 'Forms', 'seosight' ),
		'singular_name'      => __( 'Form', 'seosight' ),
		'menu_name'          => __( 'Forms', 'seosight' ),
		'name_admin_bar'     => __( 'Form', 'seosight' ),
		'add_new'            => __( 'Add New', 'seosight' ),
		'add_new_item'       => __( 'Add New Form', 'seosight' ),
		'new_item'           => __( 'New Form', 'seosight' ),
		'edit_item'          => __( 'Edit Form', 'seosight' ),
		'view_item'          => __( 'View Form', 'seosight' ),
		'view_items'         => __( 'View Forms', 'seosight' ),
		'all_items'          => __( 'All Forms', 'seosight' ),
		'search_items'       => __( 'Search Forms', 'seosight' ),
		'parent_item_colon'  => __( 'Parent Forms:', 'seosight' ),
		'attributes'         => __( 'Form Attributes', 'seosight' ),
		'not_found'          => __( 'No Forms found.', 'seosight' ),
		'not_found_in_trash' => __( 'No Forms found in Trash.', 'seosight' )
	);

	return wp_parse_args( $overrides, $defaults );
}


$args = array(
	'labels'             => _crum_form_createLabels(),
	'public'             => true,
	'publicly_queryable' => true,
	'show_ui'            => true,
	'show_in_menu'       => true,
	'query_var'          => true,
	'rewrite'            => array( 'slug' => 'form' ),
	'capability_type'    => 'post',
	'has_archive'        => true,
	'hierarchical'       => false,
	'menu_position'      => 20,
	'menu_icon'          => 'dashicons-editor-table',
	'supports'           => array( 'title', 'thumbnail', 'page-attributes' )
);
if ( function_exists( 'fw_ext' ) && fw_ext( 'forms' ) ) {
	register_post_type( 'crum-form', $args );
}
